#!/bin/sh

# Check for sab stage file.
if [ -e /app/config/app.sab.stage ]
then
	rm /app/config/app.sab
	mv /app/config/app.sab.stage /app/config/app.sab
	chown 500:500 /app/config/app.sab
fi

# Check for scode stage file.
if [ -e /app/config/kits.scode.stage ]
then
	/scripts/read-write.sh
	rm /app/config/kits.scode
	mv /app/config/kits.scode.stage /app/config/kits.scode
	chown 500:500 /app/config/kits.scode
	sleep 1
	/scripts/read-only.sh
fi		

# Check for sedona application; copy default if not there.
if [ ! -e /app/config/app.sab ]
then
	cp -a /app/scripts/app.sab /app/config/app.sab
	chown 500:500 /app/config/app.sab
fi		

# Check for sedona scode; copy default if not there.
if [ ! -e /app/config/kits.scode ]
then
	cp -a /app/scripts/kits.scode /app/config/kits.scode
	chown 500:500 /app/config/app.sab
fi		

# Start Sedona                                                                  
/app/bin/svm.bin --plat --home=/data/config kits.scode app.sab 2>&1 | tee /var/log/svm.log &

# And done.
exit 0

